IF EXISTS( SELECT * FROM SYS.PROCEDURES
			 WHERE NAME = 'P_INCLUI_PRECO_FAMILIA')
BEGIN
    DROP PROCEDURE P_INCLUI_PRECO_FAMILIA;
END;
GO


CREATE PROCEDURE [dbo].[P_INCLUI_PRECO_FAMILIA](@CD_ALT_PRECO INT)
AS
	SET NOCOUNT ON 
/*
=======================================================================================
'Job.................: Linx - Atualizacao de precos
'Função..............: Altera o preco de produtos baseado na familia do primeiro do grupo (CD_ALT_PRECO).  1 O produto - Origem_preco = 0 Outros produtos - Origem_preco = 1
'Objetivo............:  
'Tabelas.............: 
'Dt Modificação......: 22/06/2021
'Modificação.........: Tag #A001 Realizar atualização de preço por familia via agendamento  
'=======================================================================================
Tag #A001 - Alteração do codigo  
Tag #I001 - Inclusão de novo codigo 
*/

	DECLARE @CD_FAMILIA INT,
			@CD_PROD	INT,
			@VLR_TABELA MONEY,	   
			@VLR_OFERTA MONEY
	DECLARE @DT_REF DATE
	    SET @DT_REF=GETDATE()
	
	
	
	IF  @CD_ALT_PRECO IS NOT NULL  
	BEGIN 
 

		

 
		SELECT TOP 1 
				   @CD_PROD    = CD_PROD
			      ,@VLR_TABELA = VLR_TABELA
			      ,@VLR_OFERTA = VLR_OFERTA
		  FROM EST_PROD_PRECO_ALT_CPL
		 WHERE CD_EMP = 1
		   AND CD_ALT_PRECO = @CD_ALT_PRECO
     
		SET @CD_FAMILIA =( SELECT TOP 1 CD_ARV_MERC_FAMILIA FROM EST_PROD_EST_ARV_MERCADOLOGICA WHERE CD_EMP = 1 AND CD_PROD = @CD_PROD); 

		
		--SE FOR FAMILIA NAO DEFINIDO SAI DA ROTINA
		IF ISNULL(@CD_FAMILIA,0) =0
		BEGIN
		   PRINT 'PRODUTO DE FAMILIA NAO DEFINIDA - ABORTANDO OPERACAO'
		   RETURN;
		END
	
		--SE FLAG NAO ESTIVER MARCADA, NAO CONTINUA
		IF (SELECT TOP 1 APLICAR_PRECO_FAMILIA FROM EST_PROD_PRECO_ALT WHERE CD_ALT_PRECO = @CD_ALT_PRECO) =0
		BEGIN
		   PRINT 'FLAG APLICAR_PRECO_FAMILIA NAO SELECIONADA - ABORTANDO OPERACAO'
		   RETURN;
		END
---------------------------------------------------------------------------------------------------------------------------
/* Insere os produtos com o novo preco */
---------------------------------------------------------------------------------------------------------------------------

	   INSERT INTO EST_PROD_PRECO_ALT_CPL
	   SELECT  
		  ARV_MERC.CD_EMP, 
		  A.CD_ALT_PRECO, 
		  ARV_MERC.CD_PROD, 
		  @VLR_TABELA, 
		  @VLR_OFERTA, 
		  A.VLR_CUSTO, 
		  A.CD_FILIAL, 
		  A.CD_NF, 
		  A.TP_NIVEL_PERC, 
		  A.PERC_MARGEM, 
		  A.DS_PERC_MARGEM, 
		  A.TP_CUSTO, 
		  A.DS_TP_CUSTO, 
		  A.VLR_TABELA_ORIGINAL, 
		  A.VLR_TABELA_VIGENTE, 
		  A.VLR_OFERTA_VIGENTE, 
		  A.CD_ALT_PRECO_ANTERIOR, 
		  A.PERC_VARIACAO_AUMENTO, 
		  1 AS ORIGEM_PRECO
	   FROM 
		  EST_PROD_EST_ARV_MERCADOLOGICA ARV_MERC
		  JOIN EST_PROD_PRECO_ALT_CPL A ON 
				A.CD_EMP				    = ARV_MERC.CD_EMP
			 AND ARV_MERC.CD_ARV_MERC_FAMILIA = @CD_FAMILIA
	   WHERE 
		  A.CD_EMP = 1
		  AND A.CD_ALT_PRECO	 =  @CD_ALT_PRECO
		  AND ARV_MERC.CD_PROD	 <> @CD_PROD
		  and a.CD_PROD		     =  @CD_PROD;

	END
	ELSE 
		BEGIN 
		 
			
			DECLARE C1 CURSOR
			FOR 
			         SELECT DISTINCT 
					   	    EST_PROD_PRECO_ALT.CD_ALT_PRECO 
					   FROM EST_PROD_PRECO_ALT 
					   	    INNER JOIN EST_PROD_PRECO_ALT_CPL ON EST_PROD_PRECO_ALT.CD_EMP       = EST_PROD_PRECO_ALT_CPL.CD_EMP 
					   									     AND EST_PROD_PRECO_ALT.CD_ALT_PRECO = EST_PROD_PRECO_ALT_CPL.CD_ALT_PRECO 
					   	 
 				      WHERE EST_PROD_PRECO_ALT.APLICADO IN (0,2)
					    AND EST_PROD_PRECO_ALT.CD_EMP=1
					    AND ISNULL(EST_PROD_PRECO_ALT.DT_AGENDADA,'20000101') <=@DT_REF
					    AND EST_PROD_PRECO_ALT.APLICAR_PRECO_FAMILIA = 1
			
			OPEN C1;
			FETCH NEXT FROM C1 INTO @CD_ALT_PRECO;
			WHILE @@FETCH_STATUS = 0
			   
			    BEGIN
				PRINT 'CD_ALT_PRECO : '+ CONVERT(VARCHAR(50),@CD_ALT_PRECO) 

						SELECT TOP 1 
								   @CD_PROD    = CD_PROD
							      ,@VLR_TABELA = VLR_TABELA
							      ,@VLR_OFERTA = VLR_OFERTA
						  FROM EST_PROD_PRECO_ALT_CPL
						 WHERE CD_EMP = 1
						   AND CD_ALT_PRECO = @CD_ALT_PRECO
				     
						SET @CD_FAMILIA =( SELECT TOP 1 CD_ARV_MERC_FAMILIA FROM EST_PROD_EST_ARV_MERCADOLOGICA WHERE CD_EMP = 1 AND CD_PROD = @CD_PROD); 
				
					PRINT 'CD_FAMILIA : '+ CONVERT(VARCHAR(50),@CD_FAMILIA) 		
						--SE FOR FAMILIA NAO DEFINIDO SAI DA ROTINA
						IF ISNULL(@CD_FAMILIA,0) =0
						BEGIN
						   PRINT 'PRODUTO DE FAMILIA NAO DEFINIDA - ABORTANDO OPERACAO'
						   RETURN;
						END
					
			 
						---------------------------------------------------------------------------------------------------------------------------
						/* Insere os produtos com o novo preco */
						---------------------------------------------------------------------------------------------------------------------------
				
					   INSERT INTO EST_PROD_PRECO_ALT_CPL
					   SELECT  
						  ARV_MERC.CD_EMP, 
						  A.CD_ALT_PRECO, 
						  ARV_MERC.CD_PROD, 
						  @VLR_TABELA, 
						  @VLR_OFERTA, 
						  A.VLR_CUSTO, 
						  A.CD_FILIAL, 
						  A.CD_NF, 
						  A.TP_NIVEL_PERC, 
						  A.PERC_MARGEM, 
						  A.DS_PERC_MARGEM, 
						  A.TP_CUSTO, 
						  A.DS_TP_CUSTO, 
						  A.VLR_TABELA_ORIGINAL, 
						  A.VLR_TABELA_VIGENTE, 
						  A.VLR_OFERTA_VIGENTE, 
						  A.CD_ALT_PRECO_ANTERIOR, 
						  A.PERC_VARIACAO_AUMENTO, 
						  1 AS ORIGEM_PRECO
					   FROM 
						  EST_PROD_EST_ARV_MERCADOLOGICA ARV_MERC
						  JOIN EST_PROD_PRECO_ALT_CPL A ON A.CD_EMP				    = ARV_MERC.CD_EMP
													   AND ARV_MERC.CD_ARV_MERC_FAMILIA = @CD_FAMILIA
																
					   WHERE 
						  A.CD_EMP = 1
						  AND A.CD_ALT_PRECO	 = @CD_ALT_PRECO
						  AND ARV_MERC.CD_PROD	 <> @CD_PROD
						  AND A.CD_PROD		     = @CD_PROD
						  AND NOT EXISTS (SELECT * 
											FROM EST_PROD_PRECO_ALT_CPL
										   WHERE EST_PROD_PRECO_ALT_CPL.CD_ALT_PRECO = A.CD_ALT_PRECO
										     AND EST_PROD_PRECO_ALT_CPL.CD_PROD <> A.CD_PROD	 )
						 
									   
			FETCH NEXT FROM C1 INTO @CD_ALT_PRECO
			      END
			CLOSE C1;
			DEALLOCATE C1;

	 

		END 

